/* XOP_Menus.c - NL - XOP School - 1996 */

#include "XOP_Features.h"

#if defined(XOP_ADDS_MENUS) || defined (XOP_ADDS_ITEMS_TO_IGOR_MENUS)

#include "XOP_Globals.h"
#include "XOP_ResourceDefs.h"
#include "XOP_Menus.h"
#include "math.h"
#include "Parameters.h"
#include "x2DPlots.h"
#include "string.h"
#include <StdIO.h>

//#include "XOPSupport.h"

/* All structures are 68000-aligned. */
#if GENERATINGPOWERPC
#pragma options align=mac68k
#endif
//waveHndl FetchWave(char *waveName);

//
// MISC #DEFINEs 
//
#pragma mark #Defines



//
// LOCAL PROTOTYPES 
//
#pragma mark  Local Prototypes 

static int     MainMenu_Do          (short itemNumber);
static void    XOP_Menu_Enable_Item (MenuHandle menu,short itemNr,Boolean enabled);


//
// LOCAL GLOBALS (static lg_)
//
#pragma mark  Local Globals 

static MenuHandle lg_XOPMainMenu = NIL; 

/* 
  other menus (or submemus)...
*/
     

//
// 										   CODE   
//
#pragma mark ----------------------------
void
SetIgorNumVar(char *varName, DOUBLE varValue)
{
	DOUBLE d1, d2=0;
	int err;
	
	d1 = varValue;
	err = StoreNumVar(varName, &d1, &d2);
	if (err == -1) {							/* variable does not exist ? */
		Variable(varName, NT_FP64);				/* create variable */
		StoreNumVar(varName, &d1, &d2);
	}
}


int Display_or_Update(char s[255])
{
DOUBLE	dummydoub, test;
char command[255];
int	result;
//	Affichage ou mise a jour du graphe correspondant
	result = XOPSilentCommand("String/G WList");

// Tester si la fenetre existe dj
	SetIgorNumVar("test",(DOUBLE) 0);
	sprintf(command,"WList = Winlist(\"%s_w\",\";\",\"WIN:1\");test=strlen(WList)\015",s);
	if (result=XOPSilentCommand(command))	return(0);
	(void) FetchNumVar("test", &test, &dummydoub);
	if ((test != 0)&&(PlotTheData == 1)) {	// la fenetre existe
		sprintf(command,"DoWindow/K %s_w\015",s);	XOPSilentCommand(command);	//  la fermer
	}
	if ((test == 0)||(PlotTheData == 1)) 	// la fenetre n'existe pas ou vient d'tre tue
//		Tracer
	{
		if(HistogrammeBiDim==1) {
			sprintf(command, "Display;AppendMatrixContour %s;ModifyContour %s labels=0",s,s);
			XOPSilentCommand(command);
//			sprintf(command, "AppendImage %s;ModifyImage %s ctab= {*,*,Terrain,0}",s,s);
//			XOPSilentCommand(command);
		}
		else {
			sprintf(command, "Display; append %s;ModifyGraph grid=1,mirror=1",s);
			XOPSilentCommand(command);
		}
//		titre du graphe
//		sprintf(command,"Textbox/N=text0/A=MC \042%s\042",s);	XOPSilentCommand(command);	

//		result = XOPCommand("ModifyGraph width={perUnit,pix,bottom},height={perUnit,pix,left}");	return 0;
		sprintf(command,"DoWindow/C %s_w\015",s);	XOPSilentCommand(command);	// Nommer la fentre
	}
	else	{
		sprintf(command,"DoWindow/F %s_w\015",s);	XOPSilentCommand(command);	//  fentre devant
	}
	return 0;
}
//----------------------------------------------------------------------------------------------------
 short Hist_Bi_Dim()
{
int		result=0, type = NT_FP32, overwrite = 1;
char 	waveName[MAX_OBJ_NAME+1];
long 	dimensionSizes[MAX_DIMENSIONS+1];
DOUBLE 	value[2] ={0.0,0.0},value2[2] ={0.0,0.0},/* xMin, xMax, yMin, yMax, */Dx, Dy;
DOUBLE	valueFilter[2] ={0,0};
long 	i;
long 	indices[MAX_DIMENSIONS]={0,0,0,0}, index[MAX_DIMENSIONS]={0,0,0,0};
//waveHndl wx, wy;
waveHndl wx, wy, wz, wFilter;
long	NxPnts, NyPnts;
char	s[255];
DOUBLE	dummydoub, test;
char 	command[255];

	wx = FetchWave(XwaveText);	if (wx==NULL) return (NOWAV);	NxPnts = WavePoints(wx);
	if(HistogrammeBiDim==1) {
		wy = FetchWave(YwaveText);	if (wy==NULL) return (NOWAV);	NyPnts = WavePoints(wy);
		if (NxPnts != NyPnts) {
			(void)XOP_Alert(ALRT_OK,ICN_STOP, "\pX & Y waves not same size !","\p ");
			return (0);
		}
	}
//	Si on filtre par une autre wave alors il faut qu'elle existe
	if (Filter_Condition	!=0){ 
	switch (Filter_Condition) {
	case x1_Condition:	wFilter = FetchWave("x1");	if (wFilter==NULL) return (NOWAV);	break;
	case y1_Condition:	wFilter = FetchWave("y1");	if (wFilter==NULL) return (NOWAV);	break;
	case t1_Condition:	wFilter = FetchWave("t1");	if (wFilter==NULL) return (NOWAV);	break;
	case x2_Condition:	wFilter = FetchWave("x2");	if (wFilter==NULL) return (NOWAV);	break;
	case y2_Condition:	wFilter = FetchWave("y2");	if (wFilter==NULL) return (NOWAV);	break;
	case t2_Condition:	wFilter = FetchWave("t2");	if (wFilter==NULL) return (NOWAV);	break;
	case P1_Condition:	wFilter = FetchWave("P1");	if (wFilter==NULL) return (NOWAV);	break;
	case P2_Condition:	wFilter = FetchWave("P2");	if (wFilter==NULL) return (NOWAV);	break;
	case P3_Condition:	wFilter = FetchWave("P3");	if (wFilter==NULL) return (NOWAV);	break;
	case Psi_Condition:	wFilter = FetchWave("Ang12");	if (wFilter==NULL) return (NOWAV);	break;
	case Xi_Condition:	wFilter = FetchWave("Ang13");	if (wFilter==NULL) return (NOWAV);	break;
	case Ups_Condition:	wFilter = FetchWave("Ang23");	if (wFilter==NULL) return (NOWAV);	break;
	case Etot_Condition:wFilter = FetchWave("Etot");if (wFilter==NULL) return (NOWAV);	break;
	case E1_Condition:	wFilter = FetchWave("E1");	if (wFilter==NULL) return (NOWAV);	break;
	case E2_Condition:	wFilter = FetchWave("E2");	if (wFilter==NULL) return (NOWAV);	break;
	case E3_Condition:	wFilter = FetchWave("E3");	if (wFilter==NULL) return (NOWAV);	break;
		}	
	}
	if( (xMin==0)&&(xMax==0)) {	// pas de limites dfinies dans le dialogue...
//		Recherche de Min et max
		MDGetNumericWavePointValue(wx, indices, value); 
		xMin = value[0];xMax = value[0];
		for (i=1;i<NxPnts;i++){
			indices[0]=i;
			MDGetNumericWavePointValue(wx, indices, value);	
			if (xMin>value[0]) xMin=value[0];
			if (xMax<value[0]) xMax=value[0];
		}
	}
	Dx = xMax-xMin;
	
	if(HistogrammeBiDim==1) {
		if((yMin==0)&&(yMax==0)) {
			MDGetNumericWavePointValue(wy, indices, value); 
			yMin = value[0];	yMax = value[0];
			for (i=1;i<NyPnts;i++){
				indices[0]=i;
				MDGetNumericWavePointValue(wy, indices, value);	
				if (yMin>value[0]) yMin=value[0];
				if (yMax<value[0]) yMax=value[0];
			}
		}
		Dy= yMax-yMin;
	}
	else 		NyValue=0;	// Pour dfinir une wave mono-dim plus bas
	
//	-------------  Make
	strcpy(waveName, ZwaveText);
	dimensionSizes[0] = NxValue;	dimensionSizes[1] = NyValue;	dimensionSizes[2] = 0;	dimensionSizes[3] = 0;	dimensionSizes[4] = 0;

	if (result = MDMakeWave(&wz, waveName, NIL, dimensionSizes, NT_FP32, overwrite)) {
		(void)XOP_Alert(ALRT_OK,ICN_STOP, "\pMDMakeWave failed","\p ");
		return 0;
	}
	
//	-------------   RAZ
	if(HistogrammeBiDim==1)	MemClear(WaveData(wz), (long)( NxValue*NyValue*sizeof(float)));
	else MemClear(WaveData(wz), (long)( NxValue*sizeof(float)));

//	Make Histogram
	index[1] =0;	// Pour une projection mono dim
	for (i=0;i<NxPnts;i++){
		indices[0]=i;	indices[1]=0;// Indice pour lecture dans les waves sources (mono dim)
		MDGetNumericWavePointValue(wx, indices, value);
		dummydoub = (value[0]-xMin)/Dx; // entre 0 et 1 !
//		index[0] = (long)dummydoub; // entre 0 et 1 !
		if (dummydoub <1) {
		index[0] = (long)(NxValue*dummydoub);
		if(HistogrammeBiDim==1) {
			MDGetNumericWavePointValue(wy, indices, value2);
			index[1] = (long)(NyValue*(value2[0]-yMin)/Dy); // 2d Index pour la wave Z bi-dim
		}
//		if(index[1]<1) {	// si Monodim index[1] =0 !
		if (Filter_Condition != 0){ 	// On teste la valeur de filtre
			result = MDGetNumericWavePointValue(wFilter, indices, valueFilter);
			if((valueFilter[0] >= LimMin) && (valueFilter[0] <= LimMax)) {
				if(WeightWave == NULL) {	// on ajoute 1
					result = MDGetNumericWavePointValue(wz, indices, value);	
					if(!result){
						value[0]+=1;
						result = MDSetNumericWavePointValue(wz, index, value);//		if(result)return(result);
					}
				}
				else	// On ajoute le poids statistique
				{	
					result = MDGetNumericWavePointValue(WeightWave, indices, value2);	if(result)return(result);
					result = MDGetNumericWavePointValue(wz, index, value);//				if(result)return(result);
					value[0]+=value2[0];
					result = MDSetNumericWavePointValue(wz, index, value);//				if(result)return(result);
				}
			}
		}
		else 	//	Filter_Condition =0
		{		// On additionne sans filtrer
			if(WeightWave == NULL) {	// on ajoute 1
				result = MDGetNumericWavePointValue(wz, index, value);	
				if(!result){
					value[0]+=1;
					result = MDSetNumericWavePointValue(wz, index, value);
				}
			}
			else	// WeightWave dclare: On ajoute le poids statistique
			{	
				result = MDGetNumericWavePointValue(WeightWave, indices, value2);	
				if(!result) {
					result = MDGetNumericWavePointValue(wz, index, value);
					if(!result)	{
						value[0]+=value2[0];
						result = MDSetNumericWavePointValue(wz, index, value);
					}
				}
			}
		}
//	} // index[1] <1
	} // index[0] <1
	}
//	setscale/p x,18,0.1,source
	Dx/=(NxValue-1);
	sprintf(s,"SetScale/p x,%lg,%lg,%s",xMin,Dx,ZwaveText);XOPCommand(s);
	if(HistogrammeBiDim==1) {
		Dy/=(NyValue-1);	// Le nombre d'intervalles....
		sprintf(s,"SetScale/p y,%lg,%lg,%s",yMin,Dy,ZwaveText);XOPCommand(s);
	}
	else {	//  tentative de mise a l'chelle pour des nombres de points diffrents
//		sprintf(s,"%s/=%lg",XwaveText,(DOUBLE)NxValue );XOPCommand(s);XOPNotice(s);
	}
	
	if(PlotTheData!=0) Display_or_Update(ZwaveText);
	else {												// 14 aot 97 : On va amener la fentre en avant
		result = XOPSilentCommand("String/G WList");

// Tester si la fenetre existe dj
	SetIgorNumVar("test",(DOUBLE) 0);
	sprintf(command,"WList = Winlist(\"%s_w\",\";\",\"WIN:1\");test=strlen(WList)\015",s);
	if (result=XOPSilentCommand(command))	return(0);
	(void) FetchNumVar("test", &test, &dummydoub);
	if (test != 0) {																// la fenetre existe
		sprintf(command,"DoWindow/F %s_w\015",s);	XOPSilentCommand(command);	//  la fermer
	}

	}
return(0);
}

static int Get_xyt()
{
int	err;
waveHndl	w;
long	N, N1;
// Obtain x,y,t from in *pr.??? and *xy.??? files 
	w = FetchWave("mxy1"); if (w==NULL) return (NOWAV);	N = WavePoints(w);
	w = FetchWave("mxy2"); if (w==NULL) return (NOWAV);N1 = WavePoints(w);if(N!=N1) return(BAD_XWave);
	err= MakeWave(&w,"x1",N,NT_FP32,1);if(err) return(NOMEM);
	err= MakeWave(&w,"y1",N,NT_FP32,1);if(err) return(NOMEM);
	err= MakeWave(&w,"x2",N,NT_FP32,1);if(err) return(NOMEM);
	err= MakeWave(&w,"y2",N,NT_FP32,1);if(err) return(NOMEM);	
	XOPCommand("y1=trunc(mxy1/100);y2=trunc(mxy2/100)");
	XOPCommand("x1=mxy1-100*y1;y2=mxy2-100*y2");
return (0);
}
//----------------------------------------------------------------------------------------
// Routine : XOP_InitMenus
//---------------------------------------------------------------------------------------- 
int  XOP_Menu_Init(void)
{

   lg_XOPMainMenu  = ResourceMenuIDToMenuHandle(XOP_MAIN_MENU_ID); 
   if (lg_XOPMainMenu == NIL) goto bail;

   /* 
     other menus (or submemus)...
   */

	return(NO_ERROR);

bail :

 	return(XOP_RESOURCES_MISSING);
}

//------------------------------------------------------------------------------------
// Routine : XOP_MenuItem
//------------------------------------------------------------------------------------
int XOP_Menu_Item(void)
{
	int result = NO_ERROR                    ;
	int actualMenuID    , menuID             ; 
    int actuaItemNumber , itemNumber         ;
    int resourceMenuID  , resourceItemNumber ;
    
    #ifdef DEBUG_MODE
      Boolean    isIgorMenu;
      MenuHandle theMenu;
      Str255     itemText;
    #endif
    
	actualMenuID    = GetXOPItem(0); // get actual menu ID 	
	actuaItemNumber = GetXOPItem(1); // get actual item ID 	
    
	resourceMenuID = ActualToResourceMenuID(actualMenuID); 

	if ( resourceMenuID != 0 ) {   // menu added by XOP ?  

        menuID = resourceMenuID;   // Yes => menu belongs to XOP.

        #ifdef DEBUG_MODE
            isIgorMenu = FALSE;
        #endif

    }
    else {

        menuID = actualMenuID;     // No  => menu belongs to Igor.

        #ifdef DEBUG_MODE
            isIgorMenu = TRUE;
        #endif

    }

	resourceItemNumber = ActualToResourceItem(actualMenuID, actuaItemNumber);

	if ( resourceItemNumber != 0 )	     // item added by XOP to Igor menu ? 
		itemNumber = resourceItemNumber; // Yes 
	else											
		itemNumber = actuaItemNumber;    // No (item belongs to XOP menu)
	 
    #ifdef DEBUG_MODE
        if (!isIgorMenu) // ResourceMenuIDToMenuHandle can't be used with built-in igor menus...
           theMenu = ResourceMenuIDToMenuHandle(menuID);

        else // we use the Mac toolbox GetMHandle instead.
           theMenu = ResourceMenuIDToMenuHandle(menuID);

        GetMenuItemText(theMenu,itemNumber,itemText);
        CustomXOPNotice("XOP menu selection : MenuID=%d -- ItemNumber=%d -- ItemText=%s"
                        ,menuID,itemNumber,TooltoCStr(itemText));
    #endif

	switch (menuID) {

	   case XOP_MAIN_MENU_ID :  
	       result = MainMenu_Do(itemNumber); 
		   break;
 
       /* 
          other menus (or submemus)...
          for built-in Igor menus use the macros (IDs) defined in IgorXOP.h 
       */

	   default :
		   break; 

	}

	return(result);	
}


//------------------------------------------------------------------------------------
// Routine : XOP_MenuEnable
//------------------------------------------------------------------------------------
int XOP_Menu_Enable(void)
{
  

   return(NO_ERROR);
}

//------------------------------------------------------------------------------------
// Routine : XOP_Menu_Reset
//------------------------------------------------------------------------------------
void XOP_Menu_Reset(void)
{


}

//------------------------------------------------------------------------------------
// Routine : XOP_Menu_Enable_Item
//------------------------------------------------------------------------------------
static void  XOP_Menu_Enable_Item(MenuHandle menu,short itemNr,Boolean enabled)
{
	if (enabled) 
        EnableItem  (menu, itemNr);
	else  
        DisableItem (menu, itemNr);
}



#pragma mark ----------------------------

//------------------------------------------------------------------------------------
// Routine : DoMainMenu
//------------------------------------------------------------------------------------ 
static int MainMenu_Do(short itemNumber)
{ 
    int   result = NO_ERROR, test;
    long  status = GetXOPStatus();
	waveHndl	w;
	switch (itemNumber) {

	   case XOP_MAIN_MENU_ITEM_1  :
			result = Parameters_Do();
			if (result != -1) result =  Going_to_Center_of_mass();
            break;

       case XOP_MAIN_MENU_ITEM_2  :  // <Replace Me>
			result = Get_xyt();
		    break; 
       case XOP_MAIN_MENU_ITEM_3  :  // 
again:		result = x2DPlots_Do();
			test = 0;	HistogrammeBiDim=0;
		 	w = FetchWave(XwaveText);	if (w==NULL) test +=1;
		 	if(NxValue <= 0) test +=1;
		 	if(LimMax<LimMin) test +=1;
		 	if (test>0) goto again;

//	Les donnes prcdentes sont cohrentes avec une projection simple
		 	w = FetchWave(YwaveText);	// on veut un bi-dim?
		 	if (w!=NULL) {
		 		if(NyValue <= 0) test +=1;
		 		HistogrammeBiDim =1;
		 	}
		 	

			result = Hist_Bi_Dim();
		    break; 
	}
	return(result);	
}

int Going_to_Center_of_mass()
{
int	err;
waveHndl	wx1,wx2,wy1,wy2,wt1,wt2;
waveHndl	wp1x,wp1y,wp1z,wp2x,wp2y, wp2z,wp3x,wp3y,wp3z,wp1,wp2,wp3,wang_12,wang_13,wang_23, wEtot;
long	i, N, N1;
DOUBLE	p1x,p1y,p1z,p2x,p2y,p2z,p3x,p3y,p3z,p1,p2,p3,p1_2,p2_2,p3_2;
DOUBLE ang_13,	ang_12,Cosang_12, Cosang_13,ang_23,Etot ;
DOUBLE value[2];
DOUBLE	x1,y1,t1,x2,y2,t2;
long indices[MAX_DIMENSIONS]={0,0,0,0};

// I need to be sure that some data have been read in
// with the conventional names x1, y1; t1, x2, y2, t2
	wx1 = FetchWave("x1"); if (wx1==NULL) return (NOWAV);	N = WavePoints(wx1);
	wy1 = FetchWave("Y1"); if (wy1==NULL) return (NOWAV);	N1 = WavePoints(wy1);	if(N!=N1) return(BAD_XWave);
	wt1 = FetchWave("t1"); if (wt1==NULL) return (NOWAV);	N1 = WavePoints(wt1);	if(N!=N1) return(BAD_XWave);
	wx2 = FetchWave("x2"); if (wx2==NULL) return (NOWAV);	N1 = WavePoints(wx2);	if(N!=N1) return(BAD_XWave);
	wy2 = FetchWave("Y2"); if (wy2==NULL) return (NOWAV);	N1 = WavePoints(wy2);	if(N!=N1) return(BAD_XWave);
	wt2 = FetchWave("t2"); if (wt2==NULL) return (NOWAV);	N1 = WavePoints(wt2);	if(N!=N1) return(BAD_XWave);

// Define the new Waves to receive the results
	err= MakeWave(&wp1x,"p1x",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp1y,"p1y",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp1z,"p1z",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp2x,"p2x",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp2y,"p2y",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp2z,"p2z",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp3x,"p3x",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp3y,"p3y",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp3z,"p3z",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp1,"p1",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp2,"p2",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wp3,"p3",N,NT_FP32,1);			if(err) return(NOMEM);
	err= MakeWave(&wang_12,"ang_12",N,NT_FP32,1);	if(err) return(NOMEM);
	err= MakeWave(&wang_13,"ang_13",N,NT_FP32,1);	if(err) return(NOMEM);
	err= MakeWave(&wang_23,"ang_23",N,NT_FP32,1);	if(err) return(NOMEM);
	err= MakeWave(&wEtot,"Etot",N,NT_FP32,1);		if(err) return(NOMEM);
	for (i=0;i<N;i++){
		indices[0]=i;
		MDGetNumericWavePointValue(wx1, indices, value); x1 = value[0];
		MDGetNumericWavePointValue(wx2, indices, value); x2 = value[0];
		MDGetNumericWavePointValue(wy1, indices, value); y1 = value[0];
		MDGetNumericWavePointValue(wy2, indices, value); y2 = value[0];
		MDGetNumericWavePointValue(wt1, indices, value); t1 = value[0];
		MDGetNumericWavePointValue(wt2, indices, value); t2 = value[0];

		p1x=100*m1*facx*(x1-xcen)/t1;	value[0]= p1x;		MDSetNumericWavePointValue(wp1x, indices, value);		//	
		p1y=100*m1*facy*(y1-ycen)/t1;	value[0]= p1y;		MDSetNumericWavePointValue(wp1y, indices, value);		//	
		p1z=0.00096*V*(t1-avt1);		value[0]= p1z;		MDSetNumericWavePointValue(wp1z, indices, value);		//	
		
		p2x=100*m2*facx*(x2-xcen)/t2;	value[0]=p2x;		MDSetNumericWavePointValue(wp2x, indices, value);	//	
		p2y=100*m2*facy*(y2-ycen)/t2;	value[0]=p2y;		MDSetNumericWavePointValue(wp2y, indices, value);	//	
		p2z=0.00096*V*(t2-avt2);		value[0]=p2z;		MDSetNumericWavePointValue(wp2z, indices, value);		//	

		p3x=-(p1x+p2x);				value[0]=p3x;		MDSetNumericWavePointValue(wp3x, indices, value);	
		p3y=-(p1y+p2y);				value[0]=p3y;		MDSetNumericWavePointValue(wp3y, indices, value);	
		p3z=-(p1z+p2z);				value[0]=p3z;		MDSetNumericWavePointValue(wp3z, indices, value);

		p1_2=p1x*p1x+p1y*p1y+p1z*p1z;
		p2_2=p2x*p2x+p2y*p2y+p2z*p2z;
		p3_2=p3x*p3x+p3y*p3y+p3z*p2z;

		p1 = sqrt(p1_2);			value[0]=p1;		MDSetNumericWavePointValue(wp1, indices, value);	
		p2 = sqrt(p2_2);			value[0]=p2;		MDSetNumericWavePointValue(wp2, indices, value);
		p3 = sqrt(p3_2);			value[0]=p3;		MDSetNumericWavePointValue(wp3, indices, value);

		Cosang_12=(p2*p2-p1*p1-p3*p3)/(2*p1*p2); 
		ang_12=acos(Cosang_12);		value[0]=ang_12;	MDSetNumericWavePointValue(wang_12, indices, value);
		Cosang_13=(p3*p3-p1*p1-p2*p2)/(2*p1*p3); 
		ang_13=acos(Cosang_13);		value[0]=ang_13;	MDSetNumericWavePointValue(wang_13, indices, value);
		ang_23=2.0*3.141592628-ang_12-ang_13;value[0]=ang_23;	MDSetNumericWavePointValue(wang_23, indices, value);

		Etot= 0.5*(p1*p1/m1+p2*p2/m2);
		if (m3!=0) Etot=Etot+p3*p3/m3; 
		Etot=Etot/1.916;
		value[0]=Etot;	MDSetNumericWavePointValue(wEtot, indices, value);
	}
	return 0;
}






#if GENERATINGPOWERPC
#pragma options align=reset
#endif


#endif //-> #if defined(XOP_ADDS_MENUS) || defined (XOP_ADDS_ITEMS_TO_IGOR_MENUS)
